// Filter.cpp: implementation of the CFilter class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GrabIt.h"
#include "Filter.h"
#include <fstream.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CFilter::CFilter()
{

}

CFilter::~CFilter()
{

}


void CFilter::LoadBMPs( BOOL bGfxLite)
{
	// Load the bitmap resources
	m_bmpColor[0].LoadBitmap( IDB_BARBLUE);
	m_bmpColor[1].LoadBitmap( IDB_BARGREEN);
	m_bmpColor[2].LoadBitmap( IDB_BARRED);
	m_bmpColor[3].LoadBitmap( IDB_BARYELLOW);
	m_bmpColor[4].LoadBitmap( IDB_BARPURPLE);

	if (bGfxLite) {
		m_FilterBMPs[ITEM_HEALING5].LoadBitmap( IDB_HP5);
		m_FilterBMPs[ITEM_MANA5].LoadBitmap( IDB_MP5);
		m_FilterBMPs[ITEM_REJUV2].LoadBitmap( IDB_RP2);
		m_FilterBMPs[ITEM_JEWLRY].LoadBitmap( IDB_RING);
		m_FilterBMPs[ITEM_GEM5].LoadBitmap( IDB_GEM5);
		m_FilterBMPs[ITEM_SKULL5].LoadBitmap( IDB_SKULL5);
		m_FilterBMPs[ITEM_JEWELS].LoadBitmap( IDB_JEWEL);
		m_FilterBMPs[ITEM_CHARMS].LoadBitmap( IDB_CHARM);
		m_FilterBMPs[ITEM_TP].LoadBitmap( IDB_TPSCROLL);
		m_FilterBMPs[ITEM_ID].LoadBitmap( IDB_IDSCROLL);
	} else {
		m_FilterBMPs[ITEM_HEALING1].LoadBitmap( IDB_HP1);
		m_FilterBMPs[ITEM_HEALING2].LoadBitmap( IDB_HP2);
		m_FilterBMPs[ITEM_HEALING3].LoadBitmap( IDB_HP3);
		m_FilterBMPs[ITEM_HEALING4].LoadBitmap( IDB_HP4);
		m_FilterBMPs[ITEM_HEALING5].LoadBitmap( IDB_HP5);
		m_FilterBMPs[ITEM_MANA1].LoadBitmap( IDB_MP1);
		m_FilterBMPs[ITEM_MANA2].LoadBitmap( IDB_MP2);
		m_FilterBMPs[ITEM_MANA3].LoadBitmap( IDB_MP3);
		m_FilterBMPs[ITEM_MANA4].LoadBitmap( IDB_MP4);
		m_FilterBMPs[ITEM_MANA5].LoadBitmap( IDB_MP5);
		m_FilterBMPs[ITEM_REJUV1].LoadBitmap( IDB_RP1);
		m_FilterBMPs[ITEM_REJUV2].LoadBitmap( IDB_RP2);
		m_FilterBMPs[ITEM_JEWLRY].LoadBitmap( IDB_RING);
		m_FilterBMPs[ITEM_GEM1].LoadBitmap( IDB_GEM1);
		m_FilterBMPs[ITEM_GEM2].LoadBitmap( IDB_GEM2);
		m_FilterBMPs[ITEM_GEM3].LoadBitmap( IDB_GEM3);
		m_FilterBMPs[ITEM_GEM4].LoadBitmap( IDB_GEM4);
		m_FilterBMPs[ITEM_GEM5].LoadBitmap( IDB_GEM5);
		m_FilterBMPs[ITEM_SKULL1].LoadBitmap( IDB_SKULL1);
		m_FilterBMPs[ITEM_SKULL2].LoadBitmap( IDB_SKULL2);
		m_FilterBMPs[ITEM_SKULL3].LoadBitmap( IDB_SKULL3);
		m_FilterBMPs[ITEM_SKULL4].LoadBitmap( IDB_SKULL4);
		m_FilterBMPs[ITEM_SKULL5].LoadBitmap( IDB_SKULL5);
		m_FilterBMPs[ITEM_JEWELS].LoadBitmap( IDB_JEWEL);
		m_FilterBMPs[ITEM_CHARMS].LoadBitmap( IDB_CHARM);
		m_FilterBMPs[ITEM_TP].LoadBitmap( IDB_TPSCROLL);
		m_FilterBMPs[ITEM_ID].LoadBitmap( IDB_IDSCROLL);
	}
}


CString CFilter::GetRuneName( int runeNumber)
{
	switch (runeNumber) {
	case RUNE_EL:	return "El" ;
	case RUNE_ELD:	return "Eld" ;
	case RUNE_TIR:	return "Tir" ;	
	case RUNE_NEF:	return "Nef" ;	
	case RUNE_ETH:	return "Eth" ;	
	case RUNE_ITH:	return "Ith" ;	
	case RUNE_TAL:	return "Tal" ;	
	case RUNE_RAL:	return "Ral" ;	
	case RUNE_ORT:	return "Ort" ;	
	case RUNE_THUL:	return "Thul" ;	
	case RUNE_AMN:	return "Amn" ;	
	case RUNE_SOL:	return "Sol" ;	
	case RUNE_SHEA:	return "Shea" ;	
	case RUNE_DOL:	return "Dol" ;	
	case RUNE_HEL:	return "Hel" ;	
	case RUNE_IO:	return "Io" ;	
	case RUNE_LUM:	return "Lum" ;	
	case RUNE_KO:	return "Ko" ;	
	case RUNE_FAL:	return "Fal" ;	
	case RUNE_LEM:	return "Lem" ;	
	case RUNE_PUL:	return "Pul" ;	
	case RUNE_UM:	return "Um" ;	
	case RUNE_MAL:	return "Mal" ;	
	case RUNE_IST:	return "Ist" ;	
	case RUNE_GUL:	return "Gul" ;	
	case RUNE_VEX:	return "Vex" ;	
	case RUNE_OHM:	return "Ohm" ;	
	case RUNE_LO:	return "Lo" ;	
	case RUNE_SUR:	return "Sur" ;	
	case RUNE_BER:	return "Ber" ;	
	case RUNE_JO:	return "Jo" ;	
	case RUNE_CHAM:	return "Cham" ;	
	case RUNE_ZOD:	return "Zod" ;
	}

	return "ERROR" ;
}


CString CFilter::UpdateRunePic( int val, BOOL bGfxLite)
{
	if (!bGfxLite) {
		m_RuneBMP.DeleteObject() ;
		switch (val) {
		case 0:			m_RuneBMP.LoadBitmap( IDB_RUNEEL); break ;
		case RUNE_EL:	m_RuneBMP.LoadBitmap( IDB_RUNEEL); break ;
		case RUNE_ELD:	m_RuneBMP.LoadBitmap( IDB_RUNEELD); break ;
		case RUNE_TIR:	m_RuneBMP.LoadBitmap( IDB_RUNETIR); break ;
		case RUNE_NEF:	m_RuneBMP.LoadBitmap( IDB_RUNENEF); break ;
		case RUNE_ETH:	m_RuneBMP.LoadBitmap( IDB_RUNEETH); break ;
		case RUNE_ITH:	m_RuneBMP.LoadBitmap( IDB_RUNEITH); break ;
		case RUNE_TAL:	m_RuneBMP.LoadBitmap( IDB_RUNETAL); break ;
		case RUNE_RAL:	m_RuneBMP.LoadBitmap( IDB_RUNERAL); break ;
		case RUNE_ORT:	m_RuneBMP.LoadBitmap( IDB_RUNEORT); break ;
		case RUNE_THUL:	m_RuneBMP.LoadBitmap( IDB_RUNETHUL); break ;
		case RUNE_AMN:	m_RuneBMP.LoadBitmap( IDB_RUNEAMN); break ;
		case RUNE_SOL:	m_RuneBMP.LoadBitmap( IDB_RUNESOL); break ;
		case RUNE_SHEA:	m_RuneBMP.LoadBitmap( IDB_RUNESHAE); break ;
		case RUNE_DOL:	m_RuneBMP.LoadBitmap( IDB_RUNEDOL); break ;
		case RUNE_HEL:	m_RuneBMP.LoadBitmap( IDB_RUNEHEL); break ;
		case RUNE_IO:	m_RuneBMP.LoadBitmap( IDB_RUNEIO); break ;
		case RUNE_LUM:	m_RuneBMP.LoadBitmap( IDB_RUNELUM); break ;
		case RUNE_KO:	m_RuneBMP.LoadBitmap( IDB_RUNEKO); break ;
		case RUNE_FAL:	m_RuneBMP.LoadBitmap( IDB_RUNEFAL); break ;
		case RUNE_LEM:	m_RuneBMP.LoadBitmap( IDB_RUNELEM); break ;
		case RUNE_PUL:	m_RuneBMP.LoadBitmap( IDB_RUNEPUL); break ;
		case RUNE_UM:	m_RuneBMP.LoadBitmap( IDB_RUNEUM); break ;
		case RUNE_MAL:	m_RuneBMP.LoadBitmap( IDB_RUNEMAL); break ;
		case RUNE_IST:	m_RuneBMP.LoadBitmap( IDB_RUNEIST); break ;
		case RUNE_GUL:	m_RuneBMP.LoadBitmap( IDB_RUNEGUL); break ;
		case RUNE_VEX:	m_RuneBMP.LoadBitmap( IDB_RUNEVEX); break ;
		case RUNE_OHM:	m_RuneBMP.LoadBitmap( IDB_RUNEOHM); break ;
		case RUNE_LO:	m_RuneBMP.LoadBitmap( IDB_RUNELO); break ;
		case RUNE_SUR:	m_RuneBMP.LoadBitmap( IDB_RUNESUR); break ;
		case RUNE_BER:	m_RuneBMP.LoadBitmap( IDB_RUNEBER); break ;
		case RUNE_JO:	m_RuneBMP.LoadBitmap( IDB_RUNEJO); break ;
		case RUNE_CHAM:	m_RuneBMP.LoadBitmap( IDB_RUNECHAM); break ;
		case RUNE_ZOD:	m_RuneBMP.LoadBitmap( IDB_RUNEZOD); break ;
		}
	}

	return GetRuneName( val) ;
}


CString CFilter::AddSpecialFilter( int iFilter, int iValue, BOOL bGotInt)
{
	int	iMaxValue = 0;
	if ( m_Filter[ iFilter].m_CascadeMin == ITEM_GOLD1)
		iMaxValue = 9999 ;
	else if ( m_Filter[ iFilter].m_CascadeMin == ITEM_RUNE1)
		iMaxValue = 33 ;

	int item = 0 ;
	if (bGotInt) {
		if ((iValue > iMaxValue) || (iValue < 1)) {
			CString sTmp ;
			sTmp.Format("Please enter an integer between 1 to %d.", iMaxValue) ;
			AfxMessageBox( sTmp) ;
			return "ERROR" ;
		} else if ( iFilter == -1) {
			m_Filter[4].m_FilterValue = iValue ;
			m_Filter[4].m_MaxPickRange = 4 ;
			m_Filter[4].m_PriorityColor = 5 ;
		} else {

			for ( int item=m_Filter[ iFilter].m_CascadeMin; item<m_Filter[ iFilter].m_CascadeMax; item++) {
				if ( iValue >= m_Filter[ item+1].m_FilterValue) {
					m_Filter[ item].m_FilterValue = m_Filter[ item+1].m_FilterValue ;
					m_Filter[ item].m_MaxPickRange = m_Filter[ item+1].m_MaxPickRange ;
					m_Filter[ item].m_PriorityColor = m_Filter[ item+1].m_PriorityColor ;
				} else
					break ;
			}

			m_Filter[ item].m_FilterValue = iValue ;
			m_Filter[ item].m_MaxPickRange = m_Filter[ item].m_MaxPickRange ;
			if (m_Filter[ item].m_MaxPickRange < 4)
				m_Filter[ item].m_MaxPickRange = 4 ;
			m_Filter[ item].m_PriorityColor = m_Filter[ item].m_PriorityColor ;
		}

		CString sTmp ;
		if (m_Filter[ iFilter].m_CascadeMin == ITEM_GOLD1) {
			sTmp.Format("%d", m_Filter[ item].m_FilterValue) ;
		} else {
			sTmp.Format("%s  (#%d)", GetRuneName(m_Filter[ item].m_FilterValue), m_Filter[ item].m_FilterValue) ;
		}

		return sTmp ;

	} else {
		CString sTmp ;
		sTmp.Format("Please enter an integer between 1 to %d.", iMaxValue) ;
		AfxMessageBox( sTmp) ;
		return "ERROR" ;
	}
}


int CFilter::DelSpecialFilter( int iFilter)
{
	for (int item=iFilter; item>m_Filter[ iFilter].m_CascadeMin; item--) {
		m_Filter[ item].m_FilterValue = m_Filter[ item-1].m_FilterValue ;
		m_Filter[ item].m_MaxPickRange = m_Filter[ item-1].m_MaxPickRange ;
		m_Filter[ item].m_PriorityColor = m_Filter[ item-1].m_PriorityColor ;
	}
	m_Filter[ m_Filter[ iFilter].m_CascadeMin].m_FilterValue = 0 ;
	m_Filter[ m_Filter[ iFilter].m_CascadeMin].m_MaxPickRange = 0 ;
	m_Filter[ m_Filter[ iFilter].m_CascadeMin].m_PriorityColor = 0 ;

	return m_Filter[ iFilter].m_CascadeMin ;
}

void CFilter::CascadeUpdate( int iFilter, int iRange)
{
	// select the filter index for the array
//	int	iFilter = m_typeList.GetItemData(m_typeList.GetCurSel()) ;
	
	//cascade add/remove for every type above/below this one
	for (int i=m_Filter[ iFilter].m_CascadeMin; i<=m_Filter[ iFilter].m_CascadeMax; i++) {

		// for filters lower in quality, make sure they decrease when this one does
		if (i < iFilter) {
			if ( m_Filter[i].m_MaxPickRange > iRange)
				m_Filter[i].m_MaxPickRange = iRange ;

		// for filters higher in quality, make sure they increase when this one does
		} else if (i > iFilter) {
			if ( m_Filter[i].m_MaxPickRange < iRange)
				m_Filter[i].m_MaxPickRange = iRange ;

		// for this filter, set the new range
		} else
			m_Filter[iFilter].m_MaxPickRange = iRange ;
	}
}


void CFilter::PreCannedValues()
{
	// init gold
	for (int item=ITEM_GOLD1; item<= ITEM_GOLD5; item++) {
		m_Filter[ item].m_CascadeMin = ITEM_GOLD1 ;
		m_Filter[ item].m_CascadeMax = ITEM_GOLD5 ;
	}
	m_Filter[ITEM_GOLD1].m_MaxPickRange = 5 ;
	m_Filter[ITEM_GOLD1].m_FilterValue = 1 ;
	m_Filter[ITEM_GOLD1].m_PriorityColor = 5 ;
	m_Filter[ITEM_GOLD2].m_MaxPickRange = 10 ;
	m_Filter[ITEM_GOLD2].m_FilterValue = 500 ;
	m_Filter[ITEM_GOLD2].m_PriorityColor = 5 ;
	m_Filter[ITEM_GOLD3].m_MaxPickRange = 15 ;
	m_Filter[ITEM_GOLD3].m_FilterValue = 1000 ;
	m_Filter[ITEM_GOLD3].m_PriorityColor = 5 ;
	m_Filter[ITEM_GOLD4].m_MaxPickRange = 20 ;
	m_Filter[ITEM_GOLD4].m_FilterValue = 5000 ;
	m_Filter[ITEM_GOLD4].m_PriorityColor = 4 ;
	m_Filter[ITEM_GOLD5].m_MaxPickRange = 24 ;
	m_Filter[ITEM_GOLD5].m_FilterValue = 9999 ;
	m_Filter[ITEM_GOLD5].m_PriorityColor = 3 ;


	// init healing
	for ( item=ITEM_HEALING1; item<= ITEM_HEALING5; item++) {
		m_Filter[ item].m_CascadeMin = ITEM_HEALING1 ;
		m_Filter[ item].m_CascadeMax = ITEM_HEALING5 ;
		m_Filter[ item].m_FilterValue = 0 ;
		m_Filter[ item].m_PriorityColor = 5 ;
	}
	m_Filter[ITEM_HEALING1].m_MaxPickRange = 0 ;
	m_Filter[ITEM_HEALING2].m_MaxPickRange = 0 ;
	m_Filter[ITEM_HEALING3].m_MaxPickRange = 0 ;
	m_Filter[ITEM_HEALING4].m_MaxPickRange = 5 ;
	m_Filter[ITEM_HEALING5].m_MaxPickRange = 8 ;


	// init mana
	for ( item=ITEM_MANA1; item<= ITEM_MANA5; item++) {
		m_Filter[ item].m_CascadeMin = ITEM_MANA1 ;
		m_Filter[ item].m_CascadeMax = ITEM_MANA5 ;
		m_Filter[ item].m_FilterValue = 0 ;
		m_Filter[ item].m_PriorityColor = 5 ;
	}
	m_Filter[ITEM_MANA1].m_MaxPickRange = 0 ;
	m_Filter[ITEM_MANA2].m_MaxPickRange = 0 ;
	m_Filter[ITEM_MANA3].m_MaxPickRange = 0 ;
	m_Filter[ITEM_MANA4].m_MaxPickRange = 0 ;
	m_Filter[ITEM_MANA5].m_MaxPickRange = 5 ;


	// rejuvination
	m_Filter[ITEM_REJUV1].m_CascadeMin = ITEM_REJUV1 ;
	m_Filter[ITEM_REJUV1].m_CascadeMax = ITEM_REJUV2 ;
	m_Filter[ITEM_REJUV1].m_MaxPickRange = 5 ;
	m_Filter[ITEM_REJUV1].m_FilterValue = 0 ;
	m_Filter[ITEM_REJUV1].m_PriorityColor = 4 ;

	m_Filter[ITEM_REJUV2].m_CascadeMin = ITEM_REJUV1 ;
	m_Filter[ITEM_REJUV2].m_CascadeMax = ITEM_REJUV2 ;
	m_Filter[ITEM_REJUV2].m_MaxPickRange = 15 ;
	m_Filter[ITEM_REJUV2].m_FilterValue = 0 ;
	m_Filter[ITEM_REJUV2].m_PriorityColor = 3 ;


	// init runes
	for ( item=ITEM_RUNE1; item<= ITEM_RUNE5; item++) {
		m_Filter[ item].m_CascadeMin = ITEM_RUNE1 ;
		m_Filter[ item].m_CascadeMax = ITEM_RUNE5 ;
	}
	m_Filter[ITEM_RUNE1].m_MaxPickRange = 0 ;
	m_Filter[ITEM_RUNE1].m_FilterValue = 0 ;
	m_Filter[ITEM_RUNE1].m_PriorityColor = 5 ;
	m_Filter[ITEM_RUNE2].m_MaxPickRange = 5 ;
	m_Filter[ITEM_RUNE2].m_FilterValue = 5 ;
	m_Filter[ITEM_RUNE2].m_PriorityColor = 4 ;
	m_Filter[ITEM_RUNE3].m_MaxPickRange = 7 ;
	m_Filter[ITEM_RUNE3].m_FilterValue = 10 ;
	m_Filter[ITEM_RUNE3].m_PriorityColor = 3 ;
	m_Filter[ITEM_RUNE4].m_MaxPickRange = 10 ;
	m_Filter[ITEM_RUNE4].m_FilterValue = 20 ;
	m_Filter[ITEM_RUNE4].m_PriorityColor = 2 ;
	m_Filter[ITEM_RUNE5].m_MaxPickRange = 24 ;
	m_Filter[ITEM_RUNE5].m_FilterValue = 25 ;
	m_Filter[ITEM_RUNE5].m_PriorityColor = 1 ;


	// jewlry
	m_Filter[ITEM_JEWLRY].m_MaxPickRange = 9 ;
	m_Filter[ITEM_JEWLRY].m_FilterValue = 0 ;
	m_Filter[ITEM_JEWLRY].m_CascadeMin = ITEM_JEWLRY ;
	m_Filter[ITEM_JEWLRY].m_CascadeMax = ITEM_JEWLRY ;
	m_Filter[ITEM_JEWLRY].m_PriorityColor = 3 ;


	// init gems
	for ( item=ITEM_GEM1; item<= ITEM_GEM5; item++) {
		m_Filter[ item].m_CascadeMin = ITEM_GEM1 ;
		m_Filter[ item].m_CascadeMax = ITEM_GEM5 ;
		m_Filter[ item].m_FilterValue = 0 ;
		m_Filter[ item].m_PriorityColor = 4 ;
	}
	m_Filter[ITEM_GEM1].m_MaxPickRange = 0 ;
	m_Filter[ITEM_GEM2].m_MaxPickRange = 0 ;
	m_Filter[ITEM_GEM3].m_MaxPickRange = 5 ;
	m_Filter[ITEM_GEM4].m_MaxPickRange = 9 ;
	m_Filter[ITEM_GEM5].m_MaxPickRange = 12 ;


	// init skulls
	for ( item=ITEM_SKULL1; item<= ITEM_SKULL5; item++) {
		m_Filter[ item].m_CascadeMin = ITEM_SKULL1 ;
		m_Filter[ item].m_CascadeMax = ITEM_SKULL5 ;
		m_Filter[ item].m_FilterValue = 0 ;
		m_Filter[ item].m_PriorityColor = 4 ;
	}
	m_Filter[ITEM_SKULL1].m_MaxPickRange = 5 ;
	m_Filter[ITEM_SKULL2].m_MaxPickRange = 5 ;
	m_Filter[ITEM_SKULL3].m_MaxPickRange = 5 ;
	m_Filter[ITEM_SKULL4].m_MaxPickRange = 15 ;
	m_Filter[ITEM_SKULL5].m_MaxPickRange = 24 ;


	// jewels
	m_Filter[ITEM_JEWELS].m_MaxPickRange = 13 ;
	m_Filter[ITEM_JEWELS].m_FilterValue = 0 ;
	m_Filter[ITEM_JEWELS].m_CascadeMin = ITEM_JEWELS ;
	m_Filter[ITEM_JEWELS].m_CascadeMax = ITEM_JEWELS ;
	m_Filter[ITEM_JEWELS].m_PriorityColor = 3 ;


	// charms
	m_Filter[ITEM_CHARMS].m_MaxPickRange = 13 ;
	m_Filter[ITEM_CHARMS].m_FilterValue = 0 ;
	m_Filter[ITEM_CHARMS].m_CascadeMin = ITEM_CHARMS ;
	m_Filter[ITEM_CHARMS].m_CascadeMax = ITEM_CHARMS ;
	m_Filter[ITEM_CHARMS].m_PriorityColor = 3 ;


	// TP
	m_Filter[ITEM_TP].m_MaxPickRange = 5 ;
	m_Filter[ITEM_TP].m_FilterValue = 0 ;
	m_Filter[ITEM_TP].m_CascadeMin = ITEM_TP ;
	m_Filter[ITEM_TP].m_CascadeMax = ITEM_TP ;
	m_Filter[ITEM_TP].m_PriorityColor = 5 ;


	// ID
	m_Filter[ITEM_ID].m_MaxPickRange = 5 ;
	m_Filter[ITEM_ID].m_FilterValue = 0 ;
	m_Filter[ITEM_ID].m_CascadeMin = ITEM_ID ;
	m_Filter[ITEM_ID].m_CascadeMax = ITEM_ID ;
	m_Filter[ITEM_ID].m_PriorityColor = 5 ;

	
	// uber
	m_Filter[ITEM_UBER].m_MaxPickRange = 20 ;
	m_Filter[ITEM_UBER].m_FilterValue = 0 ;
	m_Filter[ITEM_UBER].m_CascadeMin = ITEM_UBER ;
	m_Filter[ITEM_UBER].m_CascadeMax = ITEM_UBER ;
	m_Filter[ITEM_UBER].m_PriorityColor = 1 ;
}


void CFilter::RetrieveValues()
{
	int			iRange,
				iValue,
				iPriority ;
	char		sVersion[15] ;
	ifstream	fin ;


	fin.open("GrabIt.ini") ;
	fin >> sVersion ;
	BOOL bCurrent = (strcmp(sVersion,"GrabIt1.1") == 0) ;

	if (!bCurrent)
		iRange = atoi(sVersion) ;

	BOOL bHaveRange = !bCurrent ;
	for (int item=ITEM_GOLD1; item<=ITEM_GOLD5; item++) {
		if (!bCurrent) {
			if (bHaveRange) {
				fin >> iValue ;
				bHaveRange = FALSE ;
			} else
				fin >> iRange >> iValue ;
		} else
			fin >> iRange >> iValue >> iPriority ;
		m_Filter[ item].m_MaxPickRange = iRange ;
		m_Filter[ item].m_FilterValue = iValue ;
		m_Filter[ item].m_CascadeMin = ITEM_GOLD1 ;
		m_Filter[ item].m_CascadeMax = ITEM_GOLD5 ;
		if (!bCurrent)
			m_Filter[ item].m_PriorityColor = 5 ;
		else
			m_Filter[ item].m_PriorityColor = iPriority ;
	}



	for ( item=ITEM_HEALING1; item<= ITEM_UBER; item++) {
		if (!bCurrent) {
			fin >> iRange >> iValue ;
		} else
			fin >> iRange >> iValue >> iPriority ;
		m_Filter[ item].m_MaxPickRange = iRange ;
		m_Filter[ item].m_FilterValue = iValue ;

		if ((item >= ITEM_HEALING1) && (item <= ITEM_HEALING5)) {
			m_Filter[ item].m_CascadeMin = ITEM_HEALING1 ;
			m_Filter[ item].m_CascadeMax = ITEM_HEALING5 ;
			iPriority =  bCurrent?iPriority:5 ;

		} else if ((item >= ITEM_MANA1) && (item <= ITEM_MANA5)) {
			m_Filter[ item].m_CascadeMin = ITEM_MANA1 ;
			m_Filter[ item].m_CascadeMax = ITEM_MANA5 ;
			iPriority =  bCurrent?iPriority:5 ;

		} else if ((item >= ITEM_REJUV1) && (item <= ITEM_REJUV2)) {
			m_Filter[ item].m_CascadeMin = ITEM_REJUV1 ;
			m_Filter[ item].m_CascadeMax = ITEM_REJUV2 ;
			iPriority =  bCurrent?iPriority:(ITEM_REJUV2 - item +3) ;

		} else if ((item >= ITEM_RUNE1) && (item <= ITEM_RUNE5)) {
			m_Filter[ item].m_CascadeMin = ITEM_RUNE1 ;
			m_Filter[ item].m_CascadeMax = ITEM_RUNE5 ;
			iPriority =  bCurrent?iPriority:(ITEM_RUNE5 - item +1) ;

		} else if (item == ITEM_JEWLRY) {
			m_Filter[ item].m_CascadeMin = ITEM_JEWLRY ;
			m_Filter[ item].m_CascadeMax = ITEM_JEWLRY ;
			iPriority =  bCurrent?iPriority:3 ;

		} else if ((item >= ITEM_GEM1) && (item <= ITEM_GEM5)) {
			m_Filter[ item].m_CascadeMin = ITEM_GEM1 ;
			m_Filter[ item].m_CascadeMax = ITEM_GEM5 ;
			iPriority =  bCurrent?iPriority:4 ;

		} else if ((item >= ITEM_SKULL1) && (item <= ITEM_SKULL5)) {
			m_Filter[ item].m_CascadeMin = ITEM_SKULL1 ;
			m_Filter[ item].m_CascadeMax = ITEM_SKULL5 ;
			iPriority =  bCurrent?iPriority:4 ;

		} else if (item == ITEM_JEWELS) {
			m_Filter[ item].m_CascadeMin = ITEM_JEWELS ;
			m_Filter[ item].m_CascadeMax = ITEM_JEWELS ;
			iPriority =  bCurrent?iPriority:3 ;

		} else if (item == ITEM_CHARMS) {
			m_Filter[ item].m_CascadeMin = ITEM_CHARMS ;
			m_Filter[ item].m_CascadeMax = ITEM_CHARMS ;
			iPriority =  bCurrent?iPriority:3 ;

		} else if (item == ITEM_TP) {
			m_Filter[ item].m_CascadeMin = ITEM_TP ;
			m_Filter[ item].m_CascadeMax = ITEM_TP ;
			iPriority =  bCurrent?iPriority:5 ;

		} else if (item == ITEM_ID) {
			m_Filter[ item].m_CascadeMin = ITEM_ID ;
			m_Filter[ item].m_CascadeMax = ITEM_ID ;
			iPriority =  bCurrent?iPriority:5 ;

		} else if (item == ITEM_UBER) {
			m_Filter[ item].m_CascadeMin = ITEM_UBER ;
			m_Filter[ item].m_CascadeMax = ITEM_UBER ;
			iPriority =  bCurrent?iPriority:1 ;

		}
		m_Filter[ item].m_PriorityColor = iPriority ;
	}
	fin.close() ;
}


void CFilter::DrawFilter(int iMin, int iMax, int iXPos, int iOffSet, BOOL bSpecial, CDC* memdc, CPaintDC* dc, BOOL bGfxLite)
{
	int color = 0 ;
	for ( int item=iMin; item<=iMax; item++) {
		// set the range of the previous item
		int previousRange = 0 ;
		if ( item > iMin)
			previousRange = m_Filter[ item-1].m_MaxPickRange ;

		if (m_Filter[ item].m_MaxPickRange > previousRange) {
			// as long as this has greater range than the prev quality, then draw
			//	blocks in the appropriate color
			for ( int range=24-previousRange; range>(24-m_Filter[ item].m_MaxPickRange); range--) {
				memdc->SelectObject( &m_bmpColor[color] );
				dc->BitBlt( iOffSet+(iXPos*34), range*10, 28, 9, memdc, 0, 0, SRCCOPY );
			}

			// draw a slightly smaller bitmap of the item
			if (!bSpecial) {
				// don't print if we want light gfx
				if (!bGfxLite) {
					memdc->SelectObject( &m_FilterBMPs[ item] );
					dc->StretchBlt( iOffSet+(iXPos*34)+2, (range+1)*10, 24, 24, memdc, 0, 0, 28, 28, SRCCOPY );
				}

			// print the value for this filter
			} else {
				switch (color) {
				case 0: dc->SetBkColor( RGB(0, 0, 255)) ; break ;
				case 1: dc->SetBkColor( RGB(0, 128, 0)) ; break ;
				case 2: dc->SetBkColor( RGB(255, 0 ,0)) ; break ;
				case 3: dc->SetBkColor( RGB(255, 255, 0)) ; break ;
				case 4: dc->SetBkColor( RGB(128, 0, 128)) ; break ;
				}
				char sTmp[10] ;
				switch (iMin) {
				case ITEM_GOLD1: sprintf(sTmp,"%d+", m_Filter[ item].m_FilterValue) ; break ;
				case ITEM_RUNE1: sprintf(sTmp,"%s", GetRuneName(m_Filter[ item].m_FilterValue)) ; break ;
				case ITEM_UBER:  sprintf(sTmp,"%s", "Uber") ; break ;
				}
				dc->TextOut( iOffSet+(iXPos*34)+2, (range+1)*10, sTmp ) ;
			}

			color++ ;
		}
	}
}
